<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.556344239 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A72" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA72CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA72INST_RETIRED / $InstructionsPerCycleCortexA72CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageCortexA72INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageCortexA72INST_RETIRED / $RetiredInstructionsPercentageCortexA72INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA72INST_RETIRED &gt; 0), (($BranchMPKICortexA72BR_MIS_PRED / $BranchMPKICortexA72INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA72INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA72L1D_TLB_REFILL / $L1DataTLBMPKICortexA72INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA72INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA72L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA72INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA72L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA72L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA72L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA72INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA72L1D_CACHE_REFILL / $L1DCacheMPKICortexA72INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA72L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA72L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA72L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA72INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA72L1I_CACHE_REFILL / $L1ICacheMPKICortexA72INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA72L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA72L2D_CACHE_REFILL / $L2CacheMissPercentageCortexA72L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Cortex-A72)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA72INST_RETIRED &gt; 0), (($L2CacheMPKICortexA72L2D_CACHE_REFILL / $L2CacheMPKICortexA72INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A72)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA72INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA72ISB_SPEC + $BarrierOperationsPercentageCortexA72DSB_SPEC) + $BarrierOperationsPercentageCortexA72DMB_SPEC) / $BarrierOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA72INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA72BR_IMMED_SPEC + $BranchOperationsPercentageCortexA72BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA72INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA72CRYPTO_SPEC / $CryptoOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA72INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA72DP_SPEC - $IntegerOperationsPercentageCortexA72DSB_SPEC) / $IntegerOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA72INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA72LDST_SPEC / $LoadStoreOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA72INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA72VFP_SPEC / $FloatingPointOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA72INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA72ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A72)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexA72INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexA72LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexA72INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A72)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA72LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA72LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA72LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA72LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA72ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA72LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A72)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA72INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA72LD_SPEC / $LoadOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA72INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA72ST_SPEC / $StoreOperationsPercentageCortexA72INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A72)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexA72INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexA72RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexA72INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexA72INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexA72RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexA72INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv8_Cortex_A72_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A72_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A72_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A72_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A72_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A72_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A72_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A72_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A72_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A72_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A72_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A72_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A72_metric_store_percentage" />
</template>
